<?php
/**
 * Load the parent and child theme styles
 */
add_action( 'wp_enqueue_scripts', 'twentyfifteen_wpcasa_style' );

function twentyfifteen_wpcasa_style() {

	// Parent theme styles
	wp_enqueue_style( 'twentyfifteen', get_template_directory_uri(). '/style.css' );

	// Child theme styles
	wp_enqueue_style( 'twentyfifteen-wpcasa', get_stylesheet_directory_uri(). '/style.css' );
}

/**
 * Remove .hentry from listing class
 */
add_filter( 'wpsight_get_listing_class', 'twentyfifteen_wpcasa_listing_class' );

function twentyfifteen_wpcasa_listing_class( $classes ) {
	
	// Find hentry in array
	$key = array_search( 'hentry', $classes );
	
	// Remove hentry
	unset( $classes[ $key ] );
		
	return $classes;
	
}
